/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib;

import javax.annotation.Nonnull;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.DayCycle;
import org.orecruncher.lib.Localization;

@OnlyIn(value=Dist.CLIENT)
public class MinecraftClock {
    private static final String AM = Localization.load("sndctrl.format.AM");
    private static final String PM = Localization.load("sndctrl.format.PM");
    private static final String TIME_FORMAT = Localization.load("sndctrl.format.TimeOfDay");
    protected int day;
    protected int hour;
    protected int minute;
    protected boolean isAM;
    protected DayCycle cycle = DayCycle.DAYTIME;

    public MinecraftClock() {
    }

    public MinecraftClock(@Nonnull World world) {
        this.update(world);
    }

    public void update(@Nonnull World world) {
        long time = world.func_72820_D();
        this.day = (int)(time / 24000L);
        ++this.day;
        this.hour = (int)((time -= (long)(this.day * 24000)) / 1000L);
        this.minute = (int)((double)(time -= (long)(this.hour * 1000)) / 16.666);
        this.hour += 6;
        if (this.hour >= 24) {
            this.hour -= 24;
            ++this.day;
        }
        this.isAM = this.hour < 12;
        this.cycle = DayCycle.getCycle((IWorld)world);
    }

    public int getDay() {
        return this.day;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public boolean isAM() {
        return this.isAM;
    }

    public String getTimeOfDay() {
        return this.cycle.getFormattedName();
    }

    public String getFormattedTime() {
        int h = this.hour;
        if (h > 12) {
            h -= 12;
        }
        if (h == 0) {
            h = 12;
        }
        return String.format(TIME_FORMAT, this.day, h, this.minute, this.isAM ? AM : PM, this.cycle.getFormattedName());
    }

    public String toString() {
        return '[' + this.getFormattedTime() + ' ' + this.getTimeOfDay() + ']';
    }
}

